export const viewDimensions = (dimensions, measurement) => {
	const { width, height, length } = dimensions;
	switch (true) {
		case width && !height && !length:
			return `${width} ${measurement}`;
		case height && !length && !width:
			return `${height} ${measurement}`;
		case length && !width && !height:
			return `${length} ${measurement}`;
		case width && height && !length:
			return `${width} x ${height} ${measurement}`;
		case width && length && !height:
			return `${width} x ${length} ${measurement}`;
		case height && length && !width:
			return `${length} x ${height} ${measurement}`;
		default:
			return `${length} x ${width} x ${height} ${measurement}`;
	}
};
